<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin\Website;
use App\Models\Admin\Category;
use App\Models\referredDist;

class referredDistibuttion extends Controller
{
    public function index(){
        $referreds = referredDist::orderBy('generation', 'ASC')->get();
        $website = Website::latest()->first();
        return view('backend.pages.system-setting.referred_distibution', compact('referreds', 'website'));
    }
    public function dest_store(Request $request)
    {

        $request->validate([
            'generation' => 'required|integer',
            'commission' => 'required|numeric',
        ]);

        $dest_save = referredDist::create([
            'generation' => $request->generation,
            'commission' => $request->commission,
            'slug' => uniqid('ref_dist') . time(),
            'created_at' => now('Asia/Dhaka'),
        ]);
     
        if ($dest_save) {
            return redirect()->back()->with('message', 'Referred Distribution added successfully!');
        }
        return redirect()->back()->with('error', 'Failed to add Referred Distribution.');
    }
    public function dest_delete($slug){
        // return $slug;
        $ref_dist = referredDist::where('slug', $slug)->delete();
        if($ref_dist){
          return redirect()->back()->with('message', 'Referred Distribution Delete successfully!');
        }
    }

}
